import { AfterViewInit, ElementRef, EventEmitter, OnChanges, OnInit, Renderer2, SimpleChanges } from '@angular/core';
import { ISignaturePadConfig } from '../../interfaces/signature-pad-config.interface';
export declare class SignaturePadComponent implements OnInit, OnChanges, AfterViewInit {
    protected renderer: Renderer2;
    private defaultConfig;
    protected container: HTMLElement;
    protected canvasRef: ElementRef;
    protected canvas: HTMLCanvasElement;
    protected signaturePad: any;
    protected value: any;
    protected valueChange: EventEmitter<any>;
    disabled: boolean;
    focus: boolean;
    protected config: ISignaturePadConfig;
    onEndWrapper: (value: any) => void;
    onBeginWrapper: (value: any) => void;
    constructor(renderer: Renderer2, defaultConfig?: ISignaturePadConfig);
    ngOnChanges(changes: SimpleChanges): void;
    ngOnInit(): void;
    ngAfterViewInit(): void;
    getValue(): number;
    setValue(signatureData: any): void;
    setDisabledState(isDisabled: boolean): void;
    clear(): void;
    resizeSignaturePad: () => void;
    protected handleInput(signatureData: any): void;
    handleFocus(isFocus: boolean): void;
    renderViewDisabled(): void;
    renderViewFocus(): void;
    renderViewValue(signatureData: any): void;
    protected updateConfig(config?: ISignaturePadConfig): void;
    protected resizeCanvas(): void;
    protected initializeSignaturePad(): void;
    protected isObject(val: any): boolean;
}
